/******/ (() => { // webpackBootstrap
var __webpack_exports__ = {};
/*!*****************************************************!*\
  !*** ./resources/js/design_1/parts/product_show.js ***!
  \*****************************************************/
function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
(function ($) {
  "use strict";

  $(document).ready(function () {
    var offerCountDown = $('#offerCountDown');
    if (offerCountDown.length) {
      var endtimeDate = offerCountDown.attr('data-day');
      var endtimeHours = offerCountDown.attr('data-hour');
      var endtimeMinutes = offerCountDown.attr('data-minute');
      var endtimeSeconds = offerCountDown.attr('data-second');
      offerCountDown.countdown100({
        endtimeYear: 0,
        endtimeMonth: 0,
        endtimeDate: endtimeDate,
        endtimeHours: endtimeHours,
        endtimeMinutes: endtimeMinutes,
        endtimeSeconds: endtimeSeconds,
        timeZone: ""
      });
    }
  });
  $('body').on('click', '.js-product-other-image', function (e) {
    e.preventDefault();
    var $image = $(this).find('img');
    var $mainImage = $('.js-product-main-image');
    var newPath = $image.attr('src');
    $mainImage.attr("src", newPath);
  });

  /*===========
  | Quantity
  * *********/
  function handleQuantityValue(type) {
    var input = $('.js-product-quantity-card input[name="quantity"]');
    var value = input.val();
    var productAvailabilityCount = $('#productAvailabilityCount').val();
    if (type === 'minus' && value > 1) {
      value = Number(value) - 1;
    } else if (type === 'plus') {
      value = Number(value) + 1;
    }
    if (!isNaN(productAvailabilityCount) && value > Number(productAvailabilityCount)) {
      value = Number(productAvailabilityCount);
    }
    input.val(value);
    var $productPoints = $('.js-product-points');
    var productRequirePointText = $('.js-product-require-point-text');
    if ($productPoints.length) {
      var requirePoint = value * $productPoints.val();
      $('.js-buy-with-point-show-btn').find('span').text(requirePoint);
      if (productRequirePointText.length) {
        productRequirePointText.find('span').text(value * $productPoints.val());
      }
    }
  }
  $('body').on('click', '.js-product-quantity-card .minus', function (e) {
    e.preventDefault();
    handleQuantityValue('minus');
  });
  $('body').on('click', '.js-product-quantity-card .plus', function (e) {
    e.preventDefault();
    handleQuantityValue('plus');
  });

  /*===========
  | Cart
  * *********/
  $('body').on('click', '.js-add-to-cart-btn', function (e) {
    e.preventDefault();
    var $this = $(this);
    $this.addClass('loadingbar').prop('disabled', true);
    var data = {};
    var $specifications = $('.js-product-specifications');
    if ($specifications.length) {
      data = serializeObjectByTag($specifications);
    }
    var $quantity = $('input[name="quantity"]');
    data['item_id'] = $quantity.attr("data-item");
    data['item_name'] = "product_id";
    data['quantity'] = $quantity.val();
    var path = "/cart/store";
    if ($this.attr('data-direct-payment') === 'true') {
      path = "/products/direct-payment";
    }
    $.post(path, data, function (result) {
      showToast('success', result.title, result.msg);
      if (result.redirect_to && result.redirect_to !== '') {
        window.location.href = result.redirect_to;
      } else {
        setTimeout(function () {
          window.location.reload();
        }, 2000);
      }
    }).fail(function (err) {
      $this.removeClass('loadingbar primary').prop('disabled', false);
      var errors = err.responseJSON;

      // toast
      if (errors && errors.toast_alert) {
        showToast('error', errors.toast_alert.title, errors.toast_alert.msg);
      } else if (errors && errors.msg) {
        showToast('error', errors.title, errors.msg);
      } else {
        showToast('error', oopsLang, somethingWentWrongLang);
      }
    });
  });

  /*===========
  * Installment
  * =========*/
  $('body').on('click', '.js-installments-btn', function (e) {
    var _$$val;
    e.preventDefault();
    var href = $(this).attr('href');
    var quantity = (_$$val = $('input[name="quantity"]').val()) !== null && _$$val !== void 0 ? _$$val : 1;
    var specifications = $('.js-selectable-specification-item:checked');
    var path = href + '?quantity=' + quantity;
    if (specifications.length) {
      var _iterator = _createForOfIteratorHelper(specifications),
        _step;
      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var specification = _step.value;
          var name = $(specification).attr('name');
          var value = $(specification).val();
          path += '&' + name + '=' + value;
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
    }
    window.location.href = path;
  });
})(jQuery);
/******/ })()
;