/******/ (() => { // webpackBootstrap
var __webpack_exports__ = {};
/*!**********************************************************!*\
  !*** ./resources/js/design_1/panel/course_statistics.js ***!
  \**********************************************************/
function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
(function ($) {
  "use strict";

  $(document).ready(function () {
    var $pieCharts = $('.js-pie-chart');
    if ($pieCharts.length > 0) {
      var _iterator = _createForOfIteratorHelper($pieCharts),
        _step;
      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var pieChart = _step.value;
          var $pieChart = $(pieChart);
          var series = JSON.parse($pieChart.attr('data-series'));
          var labels = JSON.parse($pieChart.attr('data-labels'));
          var elId = $pieChart.attr('data-id');
          var pieChartEl = document.querySelector("#" + elId);
          handleApexPieCharts(pieChartEl, series, labels);
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
    }

    // learningActivityChart
    handleActivityChart();

    // Students Progress Chart
    handleStudentsProgressChart();

    // Monthly Sales Chart
    handleMonthlySalesChart();

    // Visitors Chart
    handleVisitorsChart();
  });
  function handleActivityChart() {
    var $el = $('.js-learning-activity-chart');
    var seriesData = learningActivityChartSeriesData;
    var labels = learningActivityChartLabels;
    var seriesName = $el.attr('data-series-name');
    var elId = $el.attr('data-id');
    var prefixLang = $el.attr('data-prefix');
    var areaChartEl = document.querySelector("#" + elId);
    var series = [{
      name: seriesName,
      data: seriesData
    }];
    var colors = ["rgba(22, 93, 255, 0.3)"];
    handleApexAreaCharts(areaChartEl, series, colors, labels, 354, " ".concat(prefixLang), "after");
  }
  function handleMonthlySalesChart() {
    var $el = $('.js-monthly-sales-chart');
    var seriesData = monthlySalesChartSeriesData;
    var labels = monthlySalesChartLabels;
    var seriesName = $el.attr('data-series-name');
    var elId = $el.attr('data-id');
    var prefixLang = $el.attr('data-prefix');
    var areaChartEl = document.querySelector("#" + elId);
    var series = [{
      name: seriesName,
      data: seriesData
    }];
    var colors = ["rgba(22, 93, 255, 0.3)"];
    handleApexAreaCharts(areaChartEl, series, colors, labels, 354, jsCurrentCurrency, "before");
  }
  function handleStudentsProgressChart() {
    var $el = $('.js-students-progress-chart');
    var seriesData = studentsProgressChartSeriesData;
    var labels = studentsProgressChartLabels;
    var seriesName = $el.attr('data-series-name');
    var elId = $el.attr('data-id');
    var chartEl = document.querySelector("#" + elId);
    var series = [{
      name: seriesName,
      data: seriesData
    }];
    var colors = ["rgba(22, 93, 255, 0.3)"];
    handleApexBarCharts(chartEl, series, colors, labels, 354);
  }
  function handleVisitorsChart() {
    var $el = $('.js-visitors-chart');
    var seriesData = visitorsChartSeriesData;
    var labels = visitorsChartLabels;
    var seriesName = $el.attr('data-series-name');
    var elId = $el.attr('data-id');
    var chartEl = document.querySelector("#" + elId);
    var series = [{
      name: seriesName,
      data: seriesData
    }];
    var colors = ["rgba(22, 93, 255, 0.3)"];
    handleApexBarCharts(chartEl, series, colors, labels, 354);
  }
  function handleApexPieCharts($elDiv, series, labels) {
    var colors = ["rgba(63, 205, 130, 1)", "rgba(1, 112, 255, 1)", "rgba(255, 162, 0, 1)"];
    var options = {
      series: series,
      chart: {
        height: 266,
        type: 'donut'
      },
      legend: {
        position: 'bottom',
        offsetX: -16
      },
      labels: labels,
      colors: colors
    };
    var chart = new ApexCharts($elDiv, options);
    chart.render();
  }
  function handleApexAreaCharts($elDiv, series, colors, labels, height) {
    var prefix = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : null;
    var prefixType = arguments.length > 6 && arguments[6] !== undefined ? arguments[6] : "after";
    var options = {
      series: series,
      chart: {
        height: height,
        type: "area",
        toolbar: {
          show: false
        },
        dropShadow: {
          enabled: true,
          top: 12,
          left: 0,
          bottom: 0,
          right: 0,
          blur: 2,
          color: "rgba(132, 145, 183, 0.3)",
          opacity: 0.35
        },
        zoom: {
          enabled: false,
          allowMouseWheelZoom: false
        }
      },
      /*annotations: {
          xaxis: [{x: 312, strokeDashArray: 4, borderWidth: 1, borderColor: ["var(--secondary)"]}],
          points: [
              {
                  x: 312,
                  y: 52,
                  marker: {size: 6, fillColor: ["var(--primary)"], strokeColor: ["var(--card-bg)"], strokeWidth: 4, radius: 5},
                  label: {borderWidth: 1, offsetY: -110, text: "50k", style: {background: ["var(--primary)"], fontSize: "14px", fontWeight: "600"}},
              },
          ],
      },*/
      colors: colors,
      dataLabels: {
        enabled: false
      },
      stroke: {
        show: true,
        curve: "smooth",
        width: [3, 3],
        dashArray: [0, 0],
        lineCap: "round"
      },
      labels: labels,
      yaxis: {
        labels: {
          offsetX: -12,
          offsetY: 0,
          formatter: function formatter(e) {
            if (prefix) {
              if (prefixType === "after") {
                return e + prefix;
              } else {
                return prefix + e;
              }
            }
            return e;
          }
        }
      },
      grid: {
        strokeDashArray: 3,
        xaxis: {
          lines: {
            show: true
          }
        },
        yaxis: {
          lines: {
            show: false
          }
        }
      },
      legend: {
        show: false
      },
      fill: {
        type: "gradient",
        gradient: {
          type: "vertical",
          shadeIntensity: 1,
          inverseColors: false,
          opacityFrom: 0.05,
          opacityTo: 0.05,
          stops: [45, 100]
        }
      }
    };
    var chart = new ApexCharts($elDiv, options);
    chart.render();
  }
  function handleApexBarCharts($elDiv, series, colors, labels, height) {
    var options = {
      series: series,
      chart: {
        height: height,
        type: "bar",
        toolbar: {
          show: false
        }
      },
      fill: {
        type: "gradient",
        gradient: {
          shadeIntensity: 1,
          opacityFrom: 0.7,
          opacityTo: 1,
          colorStops: [{
            offset: 0,
            color: "rgba(1, 112, 255, 0.4)",
            opacity: 1
          }, {
            offset: 100,
            color: "rgba(1, 112, 255, 0.8)",
            opacity: 1
          }]
        }
      },
      plotOptions: {
        bar: {
          columnWidth: "55%",
          endingShape: "rounded",
          borderRadius: 5
        }
      },
      dataLabels: {
        enabled: false
      },
      legend: {
        show: false
      },
      yaxis: {
        labels: {
          show: false
        }
      },
      grid: {
        strokeDashArray: 3,
        xaxis: {
          lines: {
            show: false
          }
        },
        yaxis: {
          lines: {
            show: false
          }
        }
      },
      xaxis: {
        type: "week",
        categories: labels,
        axisBorder: {
          show: false,
          color: "rgba(119, 119, 142, 0.05)",
          offsetX: 0,
          offsetY: 0
        },
        axisTicks: {
          show: false,
          borderType: "solid",
          color: "rgba(119, 119, 142, 0.05)",
          width: 6,
          offsetX: 0,
          offsetY: 0
        },
        labels: {
          rotate: -90,
          style: {
            colors: "rgb(107 ,114 ,128)",
            fontSize: "12px"
          }
        }
      }
    };
    var chart = new ApexCharts($elDiv, options);
    chart.render();
  }
})(jQuery);
/******/ })()
;