/******/ (() => { // webpackBootstrap
var __webpack_exports__ = {};
/*!***************************************************!*\
  !*** ./resources/js/admin/parts/rewards_items.js ***!
  \***************************************************/
(function ($) {
  "use strict";

  var $rewardSettingModal = $('#rewardSettingModal');
  $('body').on('click', '.js-add-new-reward', function (e) {
    $rewardSettingModal.modal('show');
  });
  $('body').on('click', '.js-save-reward', function (e) {
    e.preventDefault();
    var $this = $(this);
    $this.addClass('loadingbar gray').prop('disabled', true);
    var $form = $rewardSettingModal.find('form');
    var data = $form.serializeObject();
    $.post(adminPanelPrefix + '/rewards/items', data, function (result) {
      Swal.fire({
        icon: 'success',
        html: '<h3 class="font-20 text-center text-dark-blue py-25">' + saveSuccessLang + '</h3>',
        showConfirmButton: false,
        width: '25rem'
      });
      setTimeout(function () {
        window.location.reload();
      }, 500);
    }).fail(function (err) {
      $this.removeClass('loadingbar gray').prop('disabled', false);
      var errors = err.responseJSON;
      if (errors && errors.errors) {
        Object.keys(errors.errors).forEach(function (key) {
          var error = errors.errors[key];
          var element = $form.find('[name="' + key + '"]');
          element.addClass('is-invalid');
          element.parent().find('.invalid-feedback').text(error[0]);
        });
      }
    });
  });
  $('body').on('click', '.js-edit-reward', function (e) {
    var $this = $(this);
    var id = $this.attr('data-id');
    var $form = $rewardSettingModal.find('form');
    removeAppendedInput();
    loadingSwl();
    $.get("".concat(adminPanelPrefix, "/rewards/items/").concat(id), function (result) {
      if (result && result.reward) {
        var reward = result.reward;
        $rewardSettingModal.find('input[name="score"]').val(reward.score);
        $rewardSettingModal.find('select[name="type"]').val(reward.type);
        $rewardSettingModal.find('input[name="condition"]').val(reward.condition);
        $rewardSettingModal.find('input[name="status"]').prop('checked', reward.status === 'active');
        $form.prepend("<input type=\"hidden\" name=\"reward_id\" value=\"".concat(id, "\"/>"));
        handleVisibilityInputsByType(reward.type);
        $rewardSettingModal.modal('show');
        setTimeout(function () {
          Swal.close();
        }, 500);
      }
    });
  });
  $('body').on('change', '#rewardSettingModal select[name="type"]', function () {
    var value = $(this).val();
    handleVisibilityInputsByType(value);
  });
  function handleVisibilityInputsByType(type) {
    var scoreInput = $('.js-score-input');
    var conditionInput = $('.js-condition-input');
    scoreInput.removeClass('d-none');
    if (type === 'badge') {
      scoreInput.addClass('d-none');
    }
    conditionInput.addClass('d-none');
    if ($.inArray(type, ['charge_wallet', 'account_charge', 'buy', 'buy_store_product']) !== -1) {
      conditionInput.removeClass('d-none');
    }
  }
  function removeAppendedInput() {
    var input = $rewardSettingModal.find('input[name="reward_id"]');
    if (input) {
      input.remove();
    }
  }
})(jQuery);
/******/ })()
;