<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Validation
    |--------------------------------------------------------------------------
    |
    |
    */

   'accepted' => ':attribute 必须被接受。',
'active_url' => ':attribute 必须是一个有效的 URL。',
'after' => ':attribute 必须是晚于 :date 的日期。',
'after_or_equal' => ':attribute 必须是晚于或等于 :date 的日期。',
'alpha' => ':attribute 只能包含字母。',
'alpha_dash' => ':attribute 只能包含字母、数字、短横线和下划线。',
'alpha_num' => ':attribute 只能包含字母和数字。',
'array' => ':attribute 必须是一个数组。',
'before' => ':attribute 必须是早于 :date 的日期。',
'before_or_equal' => ':attribute 必须是早于或等于 :date 的日期。',
'between' => [
    'numeric' => ':attribute 必须介于 :min 到 :max 之间。',
    'file' => ':attribute 大小必须介于 :min 到 :max 千字节之间。',
    'string' => ':attribute 长度必须介于 :min 到 :max 个字符之间。',
    'array' => ':attribute 必须包含 :min 到 :max 项。',
],
'boolean' => ':attribute 字段必须为真或假。',
'confirmed' => ':attribute 的确认输入不匹配。',
'date' => ':attribute 必须是一个有效的日期。',
'date_equals' => ':attribute 必须是等于 :date 的日期。',
'date_format' => ':attribute 必须匹配格式 :format。',
'different' => ':attribute 与 :other 必须不同。',
'digits' => ':attribute 必须是 :digits 位数字。',
'digits_between' => ':attribute 必须是介于 :min 到 :max 位的数字。',
'dimensions' => ':attribute 的图片尺寸无效。',
'distinct' => ':attribute 字段包含重复的值。',
'email' => ':attribute 必须是有效的电子邮箱地址。',
'ends_with' => ':attribute 必须以以下之一结尾：:values。',
'exists' => '所选的 :attribute 无效。',
'file' => ':attribute 必须是一个文件。',
'filled' => ':attribute 字段不能为空。',
'gt' => [
    'numeric' => ':attribute 必须大于 :value。',
    'file' => ':attribute 必须大于 :value 千字节。',
    'string' => ':attribute 必须多于 :value 个字符。',
    'array' => ':attribute 必须包含多于 :value 项。',
],
'gte' => [
    'numeric' => ':attribute 必须大于或等于 :value。',
    'file' => ':attribute 必须大于或等于 :value 千字节。',
    'string' => ':attribute 必须大于或等于 :value 个字符。',
    'array' => ':attribute 必须包含至少 :value 项。',
],
'image' => ':attribute 必须是图片。',
'in' => '所选的 :attribute 无效。',
'in_array' => ':attribute 字段在 :other 中不存在。',
'integer' => ':attribute 必须是整数。',
'ip' => ':attribute 必须是有效的 IP 地址。',
'ipv4' => ':attribute 必须是有效的 IPv4 地址。',
'ipv6' => ':attribute 必须是有效的 IPv6 地址。',
'json' => ':attribute 必须是有效的 JSON 字符串。',
'lt' => [
    'numeric' => ':attribute 必须小于 :value。',
    'file' => ':attribute 必须小于 :value 千字节。',
    'string' => ':attribute 必须少于 :value 个字符。',
    'array' => ':attribute 必须包含少于 :value 项。',
],
'lte' => [
    'numeric' => ':attribute 必须小于或等于 :value。',
    'file' => ':attribute 必须小于或等于 :value 千字节。',
    'string' => ':attribute 必须小于或等于 :value 个字符。',
    'array' => ':attribute 不能包含多于 :value 项。',
],
'max' => [
    'numeric' => ':attribute 不能大于 :max。',
    'file' => ':attribute 不能大于 :max 千字节。',
    'string' => ':attribute 不能超过 :max 个字符。',
    'array' => ':attribute 不能包含多于 :max 项。',
],
'mimes' => ':attribute 必须是类型为 :values 的文件。',
'mimetypes' => ':attribute 必须是类型为 :values 的文件。',
'min' => [
    'numeric' => ':attribute 必须至少为 :min。',
    'file' => ':attribute 大小至少为 :min 千字节。',
    'string' => ':attribute 长度至少为 :min 个字符。',
    'array' => ':attribute 必须包含至少 :min 项。',
],
'not_in' => '所选的 :attribute 无效。',
'not_regex' => ':attribute 格式无效。',
'numeric' => ':attribute 必须是数字。',
'password' => '密码不正确。',
'password_or_username' => '密码或用户名不正确。',
'present' => ':attribute 字段必须存在。',
'regex' => ':attribute 格式无效。',
'required' => ':attribute 字段为必填项。',
'required_if' => '当 :other 为 :value 时，:attribute 字段为必填项。',
'required_unless' => '除非 :other 在 :values 中，否则 :attribute 字段为必填项。',
'required_with' => '当 :values 存在时，:attribute 字段为必填项。',
'required_with_all' => '当所有 :values 存在时，:attribute 字段为必填项。',
'required_without' => '当 :values 不存在时，:attribute 字段为必填项。',
'required_without_all' => '当所有 :values 都不存在时，:attribute 字段为必填项。',
'same' => ':attribute 与 :other 必须相同。',
'size' => [
    'numeric' => ':attribute 必须为 :size。',
    'file' => ':attribute 必须为 :size 千字节。',
    'string' => ':attribute 必须为 :size 个字符。',
    'array' => ':attribute 必须包含 :size 项。',
],
'starts_with' => ':attribute 必须以以下之一开头：:values。',
'string' => ':attribute 必须为字符串。',
'timezone' => ':attribute 必须是有效的时区。',
'unique' => ':attribute 已被占用。',
'uploaded' => ':attribute 上传失败。',
'url' => ':attribute 格式无效。',
'uuid' => ':attribute 必须是有效的 UUID。',


    /*
    |--------------------------------------------------------------------------
    | Custom Validation Language Lines
    |--------------------------------------------------------------------------
    |
    | Here you may specify custom validation messages for attributes using the
    | convention "attribute.rule" to name the lines. This makes it quick to
    | specify a specific custom language line for a given attribute rule.
    |
    */

    'custom' => [
        'attribute-name' => [
            'rule-name' => 'custom-message',
        ],
    ],

    'captcha' => '验证码错误。',
    /*
    |--------------------------------------------------------------------------
    | Custom Validation Attributes
    |--------------------------------------------------------------------------
    |
    | The following language lines are used to swap our attribute placeholder
    | with something more reader friendly such as "E-Mail Address" instead
    | of "email". This simply helps us make our message more expressive.
    |
    */

    'attributes' => [],

];
